'******************************************************************************
' TCP Packet Filter
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile

Sub Tcp_packet_filter
   #if Include_smtp = 1
      If Tcp_destporth = My_smtp_server_port_h Then
         If Tcp_destportl = My_smtp_server_port_l Then
            #if Debug_http = 1
               Print "TCP-Paket Filter: SMTP "
               Print
            #endif
            Call Smtp
         End If
      End If
   #endif

   #if Include_http = 1
     If Reversed_word(tcp_destport) = 80 Then
        Call Http
     End If
   #endif

   #if Include_php_call = 1
     If Reversed_word(tcp_destport) = Php_temp_port Then
          Call php
     End If
   #endif

   #if Include_telnet = 1
     If Reversed_word(tcp_destport) = 23 Then
        Call Telnet
     End If
   #endif
End Sub

' Tcp_swap_seq_ack - six1
' swap seq, ack in buffer and incr ack by variable inc_ack
Sub Tcp_swap_seq_ack(byref Tcp_seqnum As Long , Byref Tcp_acknum As Long , Byval Inc_ack As Word)
  Local L_l As Long
  L_l = Reversed_long(tcp_seqnum)
  Tcp_seqnum = Tcp_acknum
  L_l = L_l + Inc_ack
  Tcp_acknum = Reversed_long(l_l)
End Sub

Sub Tcp_seq2ack
    Tcp_seqnum0 = Tcp_acknum0
    Tcp_seqnum1 = Tcp_acknum1
    Tcp_seqnum2 = Tcp_acknum2
    Tcp_seqnum3 = Tcp_acknum3
End Sub


Sub Tcp_inc2seq
    Tcp_acknum0 = Tcp_seqnum0
    Tcp_acknum1 = Tcp_seqnum1
    Tcp_acknum2 = Tcp_seqnum2
    Tcp_acknum3 = Tcp_seqnum3
End Sub

Sub Tcp_ip_src2dest
   'move  source_ip address to destination_ip address
    Ip_b_destaddr(1) = Ip_b_srcaddr(1)
    Ip_b_destaddr(2) = Ip_b_srcaddr(2)
    Ip_b_destaddr(3) = Ip_b_srcaddr(3)
    Ip_b_destaddr(4) = Ip_b_srcaddr(4)
    Call Tcp_src2myip
End Sub

Sub Tcp_src2myip
   'move  my_ip address to source_ip address
    Ip_b_srcaddr(1) = My_b_ipaddr(1)
    Ip_b_srcaddr(2) = My_b_ipaddr(2)
    Ip_b_srcaddr(3) = My_b_ipaddr(3)
    Ip_b_srcaddr(4) = My_b_ipaddr(4)
End Sub

Sub Tcp_swap_mac
   'move hardware source address to destination address
   Swap Eth_b_dest_mac(1) , Eth_b_src_mac(1)
   Swap Eth_b_dest_mac(2) , Eth_b_src_mac(2)
   Swap Eth_b_dest_mac(3) , Eth_b_src_mac(3)
   Swap Eth_b_dest_mac(4) , Eth_b_src_mac(4)
   Swap Eth_b_dest_mac(5) , Eth_b_src_mac(5)
   Swap Eth_b_dest_mac(6) , Eth_b_src_mac(6)
End Sub

Sub Tcp_swap_ip
   'move  source_ip address to destination_ip address
    Swap Ip_b_destaddr(1) , Ip_b_srcaddr(1)
    Swap Ip_b_destaddr(2) , Ip_b_srcaddr(2)
    Swap Ip_b_destaddr(3) , Ip_b_srcaddr(3)
    Swap Ip_b_destaddr(4) , Ip_b_srcaddr(4)
End Sub

Sub Tcp_mac_src2dest
   'move hardware source address to destination address

   Eth_b_dest_mac(1) = Eth_b_src_mac(1)
   Eth_b_dest_mac(2) = Eth_b_src_mac(2)
   Eth_b_dest_mac(3) = Eth_b_src_mac(3)
   Eth_b_dest_mac(4) = Eth_b_src_mac(4)
   Eth_b_dest_mac(5) = Eth_b_src_mac(5)
   Eth_b_dest_mac(6) = Eth_b_src_mac(6)
   Call Tcp_src2mymac
End Sub

Sub Tcp_src2mymac
   'Make ethernet module mac address the source address
   Eth_b_src_mac(1) = My_b_macaddr(1)
   Eth_b_src_mac(2) = My_b_macaddr(2)
   Eth_b_src_mac(3) = My_b_macaddr(3)
   Eth_b_src_mac(4) = My_b_macaddr(4)
   Eth_b_src_mac(5) = My_b_macaddr(5)
   Eth_b_src_mac(6) = My_b_macaddr(6)
End Sub

Sub Tcp_swap_port
    Swap Tcp_srcporth , Tcp_destporth
    Swap Tcp_srcportl , Tcp_destportl
End Sub


'-------------------------------------------------------------------------------
' TCP Header Checksum
'-------------------------------------------------------------------------------
Sub Tcp_header_checksum
   Tcp_cksum = &H00                                         'Initial chksum must be 0 during calculation
   Tcp_cksum = Tcpchecksum(tcp_header_start , Tcp_headerlength )
End Sub

'To calculate TCP checksum a "pseudo header" is added to the TCP header. This includes:

'IP Source Address 4 bytes
'IP Destination Address 4 bytes
'TCP Protocol 2 bytes
'TCP Length 2 bytes

'The Checksum Is Calculated Over All The Octets Of The Pseudo Header , Tcp Header And Data.

Sub Tcp_checksum
   Local Whulp1 As Word
   Local Tempword2 As Word
   Local Val1 As Word
   Local Val2 As Word
   Tcp_cksum = 0
   Call Tcp_srcdestchksum
   'resultaat in I_chksum32
   Tempwordh = T_ip_pktlen0
   Tempwordl = T_ip_pktlen1
   I_chksum32 = I_chksum32 + Tempword
   Tempword2 = Ip_b_vers_and_length And &H0F
   Tempword2 = Tempword2 * 4
   I_chksum32 = I_chksum32 - Tempword2
   Whulp1 = Tempword - 20
   Val2 = Highw(i_chksum32)
   Val1 = I_chksum32
   I_checksum16 = Tcpchecksum(buffer(&H23) , Whulp1 , Val2 , Val1)
   Tcp_cksuml = High(i_checksum16)
   Tcp_cksumh = Low(i_checksum16)
End Sub



Sub Tcp_srcdestchksum
   'checksum TCP header
   I_chksum32 = 0
   I_value16h = Ip_b_srcaddr(1)
   I_value16l = Ip_b_srcaddr(2)
   I_chksum32 = I_chksum32 + I_value16
   I_value16h = Ip_b_srcaddr(3)
   I_value16l = Ip_b_srcaddr(4)
   I_chksum32 = I_chksum32 + I_value16
   I_value16h = Ip_b_destaddr(1)
   I_value16l = Ip_b_destaddr(2)
   I_chksum32 = I_chksum32 + I_value16
   I_value16h = Ip_b_destaddr(3)
   I_value16l = Ip_b_destaddr(4)
   I_chksum32 = I_chksum32 + I_value16
   'proto
   I_chksum32 = I_chksum32 + Ip_b_protocol
End Sub




Sub Tcp_ack2inc
    Tcp_acknum0 = Incoming_ack0
    Tcp_acknum1 = Incoming_ack1
    Tcp_acknum2 = Incoming_ack2
    Tcp_acknum3 = Incoming_ack3
End Sub